#ifndef __MT_GRAF_PORT_WINDOW_H__
#define __MT_GRAF_PORT_WINDOW_H__

#include "MTWindow.h"
#include "MTUtilities.h"

class MTGrafPortWindow : public MTWindow
{
	public:
						MTGrafPortWindow();
		virtual			~MTGrafPortWindow();
		
		void			HandleOpenEvent(void);
		void			HandleCloseEvent(void);
		void			HandleContentEvent(EventRecord * theEvent, UInt32 flags);
		void			HandleResizeEvent(SInt32 newWidth, SInt32 newHeight);
		void			HandleUpdateEvent(void);
		
		void			HandleScrollEvent(MTWindowControlType which, SInt32 value);
		void			HandleControlEvent(ControlHandle theControl, SInt16 thePart);
		void			HandleButtonEvent(ControlHandle theControl);
		virtual void	HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
		
		void			GetZoomSizeBounds(Rect * bounds);
		UInt8			IsUniqueWindow(void)	{ return 0; }
		
		MTWindowType	GetBaseWindowType(void)	{ return kGrafPortWindowType; }
		virtual void	GetWindowName(StringPtr theString) = 0;
		
		virtual void	RecieveMessage(UInt32 messageType, UInt32 messageData) = 0;
		
		static pascal void	UserPaneDrawProc(ControlHandle theControl, SInt16 part);
	
	protected:
		short			GetWindowType(void)						{ return kWindowFullZoomGrowDocumentProc; }
		void			GetWindowSize(Rect * theRect);
		void			GetWindowStandardSize(Rect * theRect);
		void			GetWindowContentPadding(Rect * theRect)	{ SET_RECT_PTR(theRect, 0, 0, 0, 0); }
		
		virtual void	GetPortSize(UInt32 * inWidth, UInt32 * inHeight) = 0;
		virtual UInt32	GetPortDepth(void) = 0;
		virtual void	DrawToPort(GWorldPtr theWorld) = 0;
		
		void			UpdateRequest(void)	{ DrawToPort(theWorld); DrawOneControl(theView); }
		void			ExportAsPicture(const char * name);
	
	private:
		ControlUserPaneDrawUPP	userPaneDrawProcPtr;
		
		UInt32			portWidth, portHeight, portDepth;
		
		ControlHandle	theView;
		GWorldPtr		theWorld;
};

#endif /* __MT_GRAF_PORT_WINDOW_H__ */